 ; Ŀ
 ;   Beaker -  Eradicate dangerously superfluous entities.                 
 ;   Copyright 1994, 1996, 1997, 1999, 2001, 2005, 2010                    
 ;   by Rocket Software Ltd.                                               
 ;   A new concept - information with no information in it.                
 ;   Sort of like tabloid engineering.                                     
 ; 

 ; Ŀ
 ;   Subroutine AOB - find and erase blocks containing nothing but empty   
 ;   attributes.  Calls Foab and Damoc.                                    
 ; 
 (DEFUN AOB (/ killst rad total num)
  (setq rad (/ (getvar "viewsize") 25))
  (setq killst (foab))
  (write-line "Checking for empty attribute-only blocks (calling Damoc).")
  (setq total 0)
  (while killst
        (setq total (+ total (setq num (damoc (setq nam (car killst))))))
        (if (/= 0 num)
            (write-line (strcat ": " (itoa num) " insert"
                                (if (= num 1) "" "s") " destroyed.")))
        (setq killst (cdr killst)))
  (princ "\n")
  (if (> total 0)
      (prompt (strcat "\nEmpty aob blocks erased: " (itoa total) "\n"))
      (prompt "No empty aob blocks found.\n"))
 total)
 ; Ŀ
 ;   Aob end.                                                              
 ; 

 ; Ŀ
 ;   Beak - subroutine - search and destroy blocks by name.                
 ; 
 (DEFUN BEAK (namm num / ss len)
  (setq namm (strcase namm))
  (grtext -2 namm)
  (if (tblsearch "block" namm)
      (setq ss (ssget "X" (list (cons 2 namm)))))
  (if ss
     (progn
          (setq num (+ num (setq len (sslength ss))))
          (write-line (strcat namm " inserts found: " (itoa len)))
          (hit ss)))
 num)
 ; Ŀ
 ;   Beak end.                                                             
 ; 

 ; Ŀ
 ;   Beakerr - error handler.                                              
 ; 
 (DEFUN BEAKERR (shk / pos entt enam sublst vall)
  (setq *error* esav)
  (if (/= shk "Function cancelled")
      (progn
           (write-line shk)
           (write-line "Probable corrupt drawing: try auditing.")))
 (princ))
 ; Ŀ
 ;   Beakerr end.                                                          
 ; 

 ; Ŀ
 ;   Subroutine Damoc - see if any inserts of a given block need to be     
 ;   erased - that is, see if none of the attributes have visible values.  
 ; 
 (DEFUN DAMOC (nam / ss ssiz pa num pass del goon entt enam esav)
  (princ (strcat nam " ")) ; for debugging after corrupt block def. crashes
  (if (setq ss (ssget "X" (list (cons 2 nam))))
      (setq ssiz (strcat "/" (itoa (sslength ss)))))
  (setq num 0)
  (setq pass 0)
  (while (and ss (setq esav (setq enam (ssname ss num))))
         (grtext -2 (strcat (itoa (setq pass (1+ pass))) ssiz ": " nam))
         (setq del T)            ; the null hypothesis - needs to be deleted
         (setq goon T)           ; continue flag - still no reason not to erase
         (setq pa (cdr (assoc 10 (entget enam))))
         (while (and goon
                     (/= (cdr (assoc 0 (setq entt (entget enam)))) "SEQEND"))
                (if (and (and (assoc 1 entt)
                              (/= (cdr (assoc 1 entt)) " ")      ; not empty
                              (/= (cdr (assoc 1 entt)) ""))      ; not empty
                         (= (logand (cdr (assoc 70 entt)) 1) 0)) ; visible
                    (progn
                         (setq del ())
                         (setq goon ())))
                (setq enam (entnext enam)))
         (if del
            (setq num (1+ num))
            (ssdel esav ss)))
  (if (and ss (> (sslength ss) 0))
      (progn
           (hit ss)
           (setq num (sslength ss)))
      (setq num 0)))
 ; Ŀ
 ;   Damoc end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Foab - returns a list of attribute-only blocks.            
 ; 
 (DEFUN FOAB (/ rewind blnam blok namm goon ok entt killst)
  (write-line "Searching for attribute-only block names.")
  (setq rewind T)
  (while (setq blnam (cdr (assoc 2 (setq blok (tblnext "block" rewind)))))
         (grtext -2 blnam)
         (setq rewind ())
         (setq namm (cdr (assoc -2 blok)))     ; first ename after head
         (setq goon T)
         (setq ok ())
         (while (and goon namm)                ; while there is an entity
                (setq entt (entget namm))       ; the whole thing
                (if (/= (cdr (assoc 0 entt)) "ATTDEF")
                    (progn
                         (setq ok T)
                         (setq goon ())))
                (setq namm (entnext namm)))     ; next subentity ename
         (if (null ok) (setq killst (append killst (list blnam)))))
 killst)
 ; Ŀ
 ;   Foab end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Hit - mark the insertion point of all entities in a        
 ;   selection set, then entdel them.                                      
 ;   This is necessary because erasing an entity in a group will erase     
 ;   the entire group, whereas entdel gets only the specific entity.       
 ; 
 (DEFUN HIT (ss / colo rad num enam)
  (setq colo 7)
  (setq rad (/ (getvar "viewsize") 25))
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq pa (cdr (assoc 10 (entget enam))))
         (setq num (1+ num))
         (grdraw (polar pa (/ pi 4) rad) (polar pa (* 1.25 pi) rad) colo)
         (grdraw (polar pa (* pi 0.75) rad) (polar pa (* pi 1.75) rad) colo)
         (entdel enam))
 (princ))
 ; Ŀ
 ;   Hit end.                                                              
 ; 

 ; Ŀ
 ;   Isxnam: see if a given block is an xref by block name.                
 ;   Argument: Blnam, the block name.                                      
 ;   Returns T: it was an xref, or nil: it wasn't, or no such block is     
 ;   is defined in the drawing.                                            
 ; 
 (DEFUN ISXNAM (blnam / isxrf xp dat)
  (if (setq dat (tblsearch "block" blnam))
      (progn
           (setq xp (cdr (assoc 70 dat)))
           (setq isxrf (logand xp 4))))
 (if (= isxrf 4) T ()))
 ; Ŀ
 ;   Isxnam end.                                                           
 ; 
                                   
 ; Ŀ
 ;   MT - subroutine - search and destroy empty blocks.                    
 ; 
 (DEFUN MT ( / rewind blnam blnamp circa delt len num)
  (write-line "Searching for empty blocks.")
  (setq rewind T)
  (setq num 0)
  (while (setq blnam (cdr (assoc 2 (setq circa (tblnext "block" rewind)))))
         (grtext -2 blnam)
         (setq rewind ())
         (if (and (= (cdr (assoc 0 (entget (cdr (assoc -2 circa))))) "ENDBLK")
                  (null (isxnam blnam)))
             (progn
                  (if (= (substr blnam 1 1) "*")
                      (setq blnamp (strcat "`" blnam))
                      (setq blnamp blnam))
                  (if (setq delt (ssget "X" (list (cons 2 blnamp))))
                      (progn
                          (setq len (sslength delt))
                          (setq num (+ num len))
                          (hit delt)
                          (write-line (strcat (itoa len) " " blnam
                                              " inserts deleted")))))))
  (if (= num 0) (write-line "No empty blocks found."))
 num)
 ; Ŀ
 ;   MT end.                                                               
 ; 

 ; Ŀ
 ;   Subroutine Pkill - remove all points from a drawing.                  
 ; 
 (DEFUN PKILL (/ ss pnum pos num rad so txa pa dell)
  (write-line "Eradicating points.")
  (if (setq ss (ssget "X" '((0 . "POINT"))))
      (progn
           (setq pnum (sslength ss))
           (hit ss)
           (write-line (strcat "Points destroyed: " (itoa pnum))))
      (progn
           (write-line "No points found.")
           (setq pnum 0)))
 pnum)
 ; Ŀ
 ;   Pkill end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Poon - find and erase all invisible polylines.             
 ; 
 (DEFUN POON (/ ss pos so s1 segs num txa plural dell)
  (Write-line "Searching for single-vertex polylines.")
 ; Ŀ
 ;   Find all polylines in the drawing.                                    
 ; 
  (setq ss (ssget "X" '((0 . "POLYLINE"))))
  (if ss
     (progn
 ; Ŀ
 ;   If any Polylines were found:                                          
 ; 
          (setq pos 0)
          (setq pass 0)
          (setq num (strcat "/" (itoa (sslength ss))))
 ; Ŀ
 ;   While there are plines in the ss: get each, count its vertices.       
 ; 
          (while (setq so (setq s1 (ssname ss pos)))
                 (grtext -2 (strcat (itoa (setq pass (1+ pass))) num))
                 (setq segs 0)
                 (while (and (< segs 2)
                             (= "VERTEX" (cdr (assoc 0 (entget (setq s1
                                                             (entnext s1)))))))
                        (setq segs (1+ segs)))
 ; Ŀ
 ;   If there were more than one vertices, it's ok - delete from ss.       
 ; 
                 (if (> segs 1)
                     (ssdel so ss)
                     (setq pos (1+ pos))))
 ; Ŀ
 ;   All real plines have been removed from the ss.  See if any are left.  
 ; 
        (if (= (setq num (sslength ss)) 0)
            (write-line "No single-vertex polylines found.")
            (progn
 ; Ŀ
 ;   And erase the offending entities.                                     
 ; 
                 (hit ss)
                 (write-line (strcat (itoa num)
                                    " single-vertex polylines destroyed. ")))))
 ; Ŀ
 ;   End of the "If plines found" progn.                                   
 ; 
     (write-line "No polylines found."))
 (if num num 0))
 ; Ŀ
 ;   Poon end.                                                             
 ; 

 ; Ŀ
 ;   Txkill - subroutine - eradicate empty text strings.                   
 ; 
 (DEFUN TXKILL ( / rad ss ssd num nuf len lenn mmm so txa pa)
  (write-line "Searching for empty text strings.")
  (setq rad (/ (getvar "viewsize") 25))
  (setq ss (ssget "X" '((-4 . "<or") (0 . "text") (0 . "mtext") (-4 . "or>"))))
  (setq ssd (ssadd))
  (setq num 0)
  (setq nuf 0)
  (if ss (setq len (strcat "/" (itoa (sslength ss)))))
  (while (and ss (setq so (ssname ss 0)))
         (setq txa (entget so))
         (setq num (1+ num))
         (grtext -2 (strcat (itoa num) len))
         (setq mmm (cdr (assoc 1 txa)))
         (setq lenn (strlen mmm))
 ; Ŀ
 ;   Remove spaces from the front and back of the string.                  
 ; 
         (while (and (> (strlen mmm) 0)
                     (= (substr mmm (setq lenn (strlen mmm))) " "))
                (setq mmm (substr mmm 1 (1- lenn))))
         (while (and (> (setq lenn (strlen mmm)) 0)
                     (= (substr mmm 1 1) " "))
                (setq mmm (substr mmm 2)))
 ; Ŀ
 ;   See if the string is either empty or invisible.                       
 ; 
         (if (or (= lenn 0)
                 (member (strcase mmm) '("%%" "%%U" "\\A1;" "\\P")))
             (progn
                  (setq nuf (1+ nuf))
                  (ssadd so ssd)))
         (ssdel so ss))
  (if (= (setq nuf (sslength ssd)) 0)
      (write-line "No empty text strings found.")
      (progn
           (write-line (strcat "Empty text strings found: " (itoa nuf)))
           (hit ssd)))
 nuf)
 ; Ŀ
 ;   Txkill end.                                                           
 ; 

 ; Ŀ
 ;   Zelp - subroutine - find and erase all zero length polylines.         
 ; 
 (DEFUN ZELP (/ ss pos num rad so s1 blug stilok vrtx dell)
  (write-line "Searching for zero length polylines.")
  (setq ss (ssget "X" '((0 . "POLYLINE"))))
  (setq pos 0)
  (setq curr 1)
 ; Ŀ
 ;   If there is an ss.                                                    
 ; 
  (if ss
     (progn
        (setq num (itoa (sslength ss)))
        (setq rad (/ (getvar "viewsize") 25))
        (setq num (strcat "/" num))
 ; Ŀ
 ;   Step through ss of polylines.                                         
 ; 
        (while (setq so (ssname ss pos))           ; pline head entity
               (grtext -2 (strcat (itoa curr) num))
               (setq curr (1+ curr))
               (setq s1 (entnext so))              ; first vrtx (head 10 = 0,0)
               (setq subb (entget s1))             ; entity data
               (setq pa (cdr (assoc 10 subb)))     ; vertex location
               (setq etyp (cdr (assoc 0 subb)))    ; subentity type
               (setq okay ())                      ; not okay yet - null hyp.
               (while (and (null okay) (/= "SEQEND" etyp))
                      (setq subb (entget (setq s1 (entnext s1))))
                      (setq etyp (cdr (assoc 0 subb)))
                      (if (and (not (equal (cdr (assoc 10 subb)) pa))
                               (/= "SEQEND" etyp))
                          (setq okay T)))
 ; Ŀ
 ;   If the vertices weren't all at the same point.                        
 ; 
               (if okay
                  (ssdel so ss)
                  (setq pos (1+ pos))))
        (setq num (sslength ss))
        (if (> num 0)
            (progn
                 (hit ss)
                 (write-line (strcat "Zero length polylines erased: "
                                                              (itoa num))))
            (write-line "No zero length polylines found.")))
     (write-line "No standard polylines found."))
 (if num num 0))
 ; Ŀ
 ;   Zelp end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Zll - find and erase all zero length lines.                
 ;   Takes no arguments, calls Hit, returns a number.                      
 ; 
 (DEFUN ZLL (/ ss pos curr num enam entt pa elvn pos nuf)
  (write-line "Searching for zero length lines.")
 ; Ŀ
 ;   Set marker x length.                                                  
 ; 
  (if (setq ss (ssget "X" (list (cons 0 "line"))))
      (progn
           (setq pos 0)
           (setq curr 1)
           (setq num (strcat "/" (itoa (sslength ss))))
 ; Ŀ
 ;   If there is an ss, look for lines both ends of which are at the same  
 ;   point.  If any are found, mark them.  Remove other lines from the ss. 
 ; 
           (while (and ss (setq enam (ssname ss pos)))
                  (grtext -2 (strcat (itoa curr) num))
                  (setq curr (1+ curr))
                  (setq entt (entget enam))
                  (setq pa (cdr (assoc 10 entt)))
                  (setq elvn (cdr (assoc 11 entt)))
                  (if (equal pa elvn 0.000001)
                      (setq pos (1+ pos))
                      (ssdel enam ss)))))
 ; Ŀ
 ;   Now deal with the remainder.                                          
 ; 
  (if (or (null ss) (= (sslength ss) 0))
      (setq nuf 0)
      (setq nuf (sslength ss)))
  (if (= nuf 0)
      (write-line "No zero length lines found.")
      (progn
           (write-line (strcat "Zero length lines: " (itoa nuf)))
           (hit ss)))
 nuf)
 ; Ŀ
 ;   Zll end.                                                              
 ; 

 ; Ŀ
 ;   Zlwp - find and erase zero length lwpolylines.                        
 ; 
 (DEFUN ZLWP (/ ss ssnum enam entt num asoc sub sub0 lenp)
  (write-line "Searching for zero length lwpolylines.")
  (setq ss (ssget "x" (list (cons 0 "lwpolyline"))))
  (setq ssnum 0)
  (while (and ss (setq enam (ssname ss ssnum)))
         (setq entt (entget enam))
         (setq lenp ())
         (setq sub0 ())
         (setq num 0)
         (while (and (null lenp) (setq sub (nth num entt)))
                (setq num (1+ num))
                (setq asoc (car sub))
                (cond ((and (= asoc 10) sub0)
                       (if (not (equal sub sub0))
                           (setq lenp t)))
                      ((= asoc 10)
                       (setq sub0 sub))))
         (if lenp
             (ssdel enam ss)
             (setq ssnum (1+ ssnum))))
  (if (and ss (> (sslength ss) 0))
      (progn
           (setq num (sslength ss))
           (write-line (strcat "Zero length lwpolylines erased: " (itoa num)))
           (hit ss))
      (progn
           (setq num 0)
           (write-line "No zero length lwpolylines found.")))
 num)
 ; Ŀ
 ;   Zlwp end.                                                             
 ; 

 ; Ŀ
 ;   Freestanding Txkill for drawings with sacred invisible blocks.        
 ; 
 (DEFUN C:TXKILL ()
  (txkill)
 (princ))
 ; Ŀ
 ;   C:Txkil end.                                                          
 ; 

 ; Ŀ
 ;   Beaker: the main event.                                               
 ; 
 (DEFUN C:BEAKER (/ hi ss num)
  (setvar "cmdecho" 0)
  (setq esav *error*)                            ; save existing error handler
  (setq *error* beakerr)                         ; and install the new one
  (setq num 0)                                   ; erased blocks counter
  (setq hi (getvar "highlight"))                 ; save highlight setting
 ; Ŀ
 ;   First call Beak with the name of each suspicious block.               
 ;   These automatic erase calls have been moved to the top after          
 ;   working on a massively bad Enerflex drawing where corrupt blocks      
 ;   were crashing Beaker, this way there is a chance that a bad block     
 ;   will be erased before it can cause trouble.                           
 ;   Later note: this strategy worked.                                     
 ;   The alternative is to write a corrupt data finder, and these are      
 ;   in my experience difficult to make foolproof.                         
 ; 
  (setq num (beak "acad"            num))
  (setq num (beak "adev"            num))
  (setq num (beak "al-new"          num))
  (setq num (beak "al-new1"         num))
  (setq num (beak "box_29"          num))
  (setq num (beak "box_30"          num))
  (setq num (beak "box_31"          num))
  (setq num (beak "box_58"          num))
  (setq num (beak "gridcont_27"     num))
  (setq num (beak "controlpnl_28"   num))
  (setq num (beak "controlpnl_46"   num))
  (setq num (beak "layers"          num))
  (setq num (beak "ther_32"         num))
  (setq num (beak "ther_33"         num))
  (setq num (beak "ther_59"         num))
  (setq num (beak "sk_69"           num))
  (setq num (beak "sketch_67"       num))
  (setq num (beak "sketch_68"       num))
  (setq num (beak "sketch3_57"      num))
  (setq num (beak "sketch4_66"      num))
  (setq num (beak "a1mastersht"     num))
  (setq num (beak "eng"             num))
  (setq num (beak "eodept_23"       num))
 ; Ŀ
 ;   Anything below this line is a Cadpipe vestigial block.                
 ; 
  (setq num (beak "attribut"        num))
  (setq num (beak "cppv"            num))
  (setq num (beak "cpp-"            num))
  (setq num (beak "cadpipe-"        num))
 ; (setq num (beak "cp_title"       num))    ; may be a whole tb
  (setq num (beak "cp_hw1"          num))
  (setq num (beak "cp_atmrk"        num))
  (setq num (beak "gask"            num))
  (setq num (beak "gask--1-"        num))
  (setq num (beak "gask--10"        num))
  (setq num (beak "gask__10"        num))
  (setq num (beak "gask---0"        num))
  (setq num (beak "weldp---"        num))
  (setq num (beak "weldpw--"        num))
  (setq num (beak "weld-w-0"        num))
  (setq num (beak "weldp--0"        num))
  (setq num (beak "weldpw-0"        num))
  (setq num (beak "weldpw--"        num))
  (setq num (beak "weldpwi0"        num))
  (setq num (beak "weldpwi-"        num))
  (setq num (beak "weld-w--"        num))
  (setq num (beak "weld-wi-"        num))
  (setq num (beak "cp-v"            num))
  (setq num (beak "atblk"           num))
 ; Ŀ
 ;   Anything below this line is an Enerflex/Cadpipe block.                
 ;   Hey - this is already in here - we must have had lunatic drawings     
 ;   from Enerflex before.                                                 
 ; 
  (setq num (beak "bom_ins_pt"      num))
  (setq num (beak "cpldes--"        num))
  (setq num (beak "des_ins_pt"      num))
  (setq num (beak "dwg_ins_pt"      num))
  (setq num (beak "g_note_ins_pt"   num))
  (setq num (beak "nozz_ins_pt"     num))
  (setq num (beak "noz_tbl_ins_pt"  num))
  (setq num (beak "n_plate_ins_pt"  num))
  (setq num (beak "tblk1_ins_pt"    num))
  (setq num (beak "tblk2_ins_pt"    num))
  (setq num (beak "u_data_ins_pt"   num))
  (setq num (beak "weld_ins_pt"     num))
  (setq num (beak "border_ins_pt"   num))
  (setq num (beak "gask--2-"        num))
  (setq num (beak "eslins"          num))
  (setq num (beak "cp_hw2"          num))
  (setq num (beak "gaski-1-"        num))
 ; Ŀ
 ;   This next one is from MacDonald Engineering.  It seems to serve       
 ;   some drawing tracking function, but every copy I have seen is         
 ;   corrupt.                                                              
 ; 
  (setq num (beak "keyrev"          num))
 ; Ŀ
 ;   From an Apache drawing - TpDosR13 contains only Titan, which is       
 ;   empty.                                                                
 ; 
  (setq num (beak "titan"           num))
  (setq num (beak "tpdosr13"        num))
 ; Ŀ
 ;   And Procad.                                                           
 ; 
  (setq num (beak "af-std"          num))
  (setq num (beak "af-base"         num))
  (setq num (beak "af"              num))
  (setq num (beak "Ao-Base"         num))
  (setq num (beak "Ao-Std"          num))
  (setq num (beak "AO"              num))
  (setq num (beak "Autoflow"        num)) ; contains only af-base
 ;(setq num (beak "base"            num)) ; apparently we are using this for xrefs
  (setq num (beak "ai-base"         num))
 ; Ŀ
 ;   Now run through the checks for other invisible entity types.          
 ; 
  (setq num (+ num (txkill)))                    ; erase empty text strings
  (setq num (+ num (mt)))                        ; delete empty blocks
  (setq num (+ num (aob)))                       ; excise att. only blocks
  (setq num (+ num (zelp)))                      ; remove zero length polylines
  (setq num (+ num (zlwp)))                      ; remove zero length lwplines
  (setq num (+ num (zll)))                       ; evaporate zero length lines
  (setq num (+ num (poon)))                      ; destroy invisible polylines
 ;(setq num (+ num (pkill)))                     ; obliterate points
 ; Ŀ
 ;   Give the user a vague idea of the titanic struggle which has just     
 ;   taken place inside his computer.                                      
 ; 
  (if (> num 0)
      (progn
           (write-line (strcat "Superfluous entities erased: " (itoa num)))
           (write-line "This drawing should now be purged."))
      (write-line "No useless entities found."))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (setvar "highlight" hi)               ; restore highlight
  (setq *error* esav)                   ; restore the original error handler
 (princ))